from tkinter import *

animals = []

class Animal():
	name = ""
	age = 0
	legs = 4
	sound = ""
	
	def __init__(self,name,age):
		self.name = name
		self.age = age
	
	def introduction(self):
		print("Hello! My name is",self.name,". I am a",type(self).__name__,". I have",self.legs,"legs.",self.sound)
		
class Duck(Animal):
	legs = 2
	sound = "Quack!"
	
	def addDuck(name,age):
		d = Duck(name,age)
		animals.append(d)
	
class Giraffe(Animal):
	sound = "Giraffe noise!"
	
	def addGiraffe(name,age):
		g = Giraffe(name, age)	
		animals.append(g)
	
class Elephant(Animal):
	sound = "Trump!"
	
	def addElephant(name,age):
		e = Elephant(name, age)
		animals.append(e)
	
def printAnimals():
	for a in animals:
		a.introduction()	
	
class GUI():	
	def __init__(self,root):
		root.title("Animals")

		labelName = Label(root,text="Name:")
		labelName.grid(column=0,row=0)
		name = Entry(root)
		name.grid(column=1,row=0)
	
		labelAge = Label(root,text="Age:")
		labelAge.grid(column=0,row=1)
		age = Entry(root)
		age.grid(column=1,row=1)

		button1 = Button(root, text="Add Duck", command= lambda: Duck.addDuck(name.get(),age.get()))
		button1.grid(column=1,row=2)
		
		button2 = Button(root, text="Add Giraffe", command= lambda: Giraffe.addGiraffe(name.get(),age.get()))
		button2.grid(column=1,row=3)
		
		button3 = Button(root, text="Add Elephant", command= lambda: Elephant.addElephant(name.get(),age.get()))
		button3.grid(column=1,row=4)

		button4 = Button(root, text="Print Animals", command= lambda: printAnimals())
		button4.grid(column=1,row=5)
		
def main():
	root = Tk()
	gui = GUI(root)
	root.mainloop()

if __name__ == '__main__':
	main()		
	